package org.pgusb.usb4allAPIWrapper;

/* equivalencia entre tipos de datos en windows
 * en los tipos que se van a utilizar en la interfaz
 * http://msdn2.microsoft.com/en-us/library/aa383751.aspx
 * 
 * Windows			Tipo C              Longitud (bytes)       Jnative   claseNuestra
 * void				void					
 * DWORD			unsigned long           4					LONG (o int)			
 * PCHAR			char*					4							  PCHAR 	
 * HANDLE			void*					4					HANDLE
 * PVOID			void*					4					
 * PDWORD			unsigned long* 			4				
 * BOOL				int					    4					LONG
 */

import org.xvolks.jnative.JNative;
import org.xvolks.jnative.Type;
import org.xvolks.jnative.exceptions.NativeException;
import org.xvolks.jnative.misc.basicStructures.LONG;
import org.xvolks.jnative.pointers.NullPointer;
import org.xvolks.jnative.pointers.Pointer;
import org.xvolks.jnative.pointers.memory.HeapMemoryBlock;
import org.xvolks.jnative.pointers.memory.MemoryBlockFactory;

public class Usb4allAPIWrapper {
	//windows public static final String DLL_NAME = "Usb4AllAPI.dll";
	public static String DLL_NAME = "libUsb4AllAPI.so";
	private static boolean inicialized = false;
	//TODO investigar pasar a enums de java 5
	//enums
	//enum USBTransIN {NULL_IN= 0,BULK_IN=1,CTRL_IN,INT_IN,ISO_IN};
	public static final int NULL_IN=0;
	public static final int BULK_IN=1;
	public static final int CTRL_IN=2;
	public static final int INT_IN=3;
	public static final int ISO_IN=4;
	
	//enum USBTransOUT {NULL_OUT = 5,BULK_OUT,CTRL_OUT,INT_OUT,ISO_OUT};
	public static final int NULL_OUT=5;
	public static final int BULK_OUT=6;
	public static final int CTRL_OUT=7;
	public static final int INT_OUT=8;
	public static final int ISO_OUT=9;
	
	public static final int MAX_PACKET_SIZE = 255;
	/*
//	enums
	//enum USBTransIN {BULK_IN=1,CTRL_IN,INT_IN,ISO_IN};
	public static final int BULK_IN=1;
	public static final int CTRL_IN=2;
	public static final int INT_IN=3;
	public static final int ISO_IN=4;
	
	//enum USBTransOUT {BULK_OUT=5,CTRL_OUT,INT_OUT,ISO_OUT};
	public static final int BULK_OUT=5;
	public static final int CTRL_OUT=6;
	public static final int INT_OUT=7;
	public static final int ISO_OUT=8;
	*/
	
	//caches de las funciones de la dll
	
	/*
	
	int openDevice(char *, int , int);
    bool configDevice(int , char*);
    bool sendData(int, char*, int);
    bool receiveData(int , char*, int);
    bool closeDevice(int);
    int apiVersion();
    int firmwareVersion();
    */
	
	private static JNative f_openDevice;
    private static JNative f_configDevice;
    private static JNative f_sendData;    
    private static JNative f_receiveData;
    private static JNative f_closeDevice;
    private static JNative f_apiVersion;
    private static JNative f_firmwareVersion;
    private static JNative f_getU4ABoards;
    private static JNative f_getSerialNumber;
    
    public static void init(){
    	if (!inicialized){
	    	String osName = System.getProperty("os.name");
			if (osName.contains("Linux")){
				DLL_NAME = "libUsb4AllAPI.so";
			}
			else {
				DLL_NAME = "Usb4AllAPI.dll";
			}
			//TODO: llamar al init de la api
			
    	inicialized = true;
    	}
    }
    /*
     * wrapper de la funcion de la dll:
     * int apiVersion(void);
     */
    public static int apiVersion() throws NativeException, IllegalAccessException {
		if(f_apiVersion == null) {
            //seteo la funcion a invocar
    		f_apiVersion = new JNative(DLL_NAME, "_ZN3u4a10apiVersionEv");

            //seteo tipo de retorno (la dll devuelve un int) 
    		f_apiVersion.setRetVal(Type.INT);
    	}	
    	//invoco la funcion
    	f_apiVersion.invoke();
    	//retorno un int con el valor retornado por la funcion invocada
        return new Integer(f_apiVersion.getRetVal()).intValue();
    }  	

    /*
     * wrapper de la funcion de la dll:
     * int apiVersion(void);
     */
    public static int firmwareVersion() throws NativeException, IllegalAccessException {
		if(f_apiVersion == null) {
            //seteo la funcion a invocar
    		f_apiVersion = new JNative(DLL_NAME, "_ZN3u4a15firmwareVersionEv");
            //seteo tipo de retorno (la dll devuelve un int) 
    		f_apiVersion.setRetVal(Type.INT);
    	}	
    	//invoco la funcion
    	f_apiVersion.invoke();
    	//retorno un int con el valor retornado por la funcion invocada
        return new Integer(f_apiVersion.getRetVal()).intValue();
    }
    
    /*
     * wrapper de la funcion de la dll:
     * bool closeDevice(int);
     */
    public static int closeDevice(int handler) throws NativeException, IllegalAccessException {
		if(f_closeDevice == null) {
            //seteo la funcion a invocar
			//f_closeDevice = new JNative(DLL_NAME, "_ZN3u4a11closeDeviceEi");//carlos
			f_closeDevice = new JNative(DLL_NAME, "_ZN3u4a11closeDeviceEi");//mia
			
			//seteo tipo de retorno (la dll devuelve un int) 
			f_closeDevice.setRetVal(Type.INT);
    	}	
		//RARO para la dll usb4all exportada en c++ se empieza a poner parametros desde el 1
		f_closeDevice.setParameter(1, Type.INT, "" + handler);
    	//invoco la funcion
		f_closeDevice.invoke();
    	//retorno un int con el valor retornado por la funcion invocada
        return new Integer(f_closeDevice.getRetVal()).intValue();
    }  	
    
    /*
     * wrapper de la funcion de la dll:
     * bool sendData(int, char*, int);
     */ 
    public static int sendData(int handler, byte[] data, int len) throws NativeException, IllegalAccessException {
    	//send no blockeante
    	return sendData(handler,data,len,3000); 
    }
    
    public static int sendData(int handler, byte[] data, int len, int timeout) throws NativeException, IllegalAccessException {
    	Pointer pData = new	Pointer(MemoryBlockFactory.createMemoryBlock(MAX_PACKET_SIZE));
		pData.setMemory(data);
		if(f_sendData == null) {
            //seteo la funcion a invocar
			f_sendData = new JNative(DLL_NAME, "_ZN3u4a8sendDataEiPcii"); //carlos
			//f_sendData = new JNative(DLL_NAME, "_ZN3u4a8sendDataEjRA253_ci");//mia
		    //seteo tipo de retorno (la dll devuelve un bool) 
			f_sendData.setRetVal(Type.INT);
    	}	
		//RARO para la dll usb4all exportada en c++ se empieza a poner parametros desde el 1
		f_sendData.setParameter(1, Type.INT, "" + handler);
		f_sendData.setParameter(2, pData);
		f_sendData.setParameter(3,  Type.INT, "" +len);
		f_sendData.setParameter(4,  Type.INT, "" +timeout);
		//invoco la funcion
		f_sendData.invoke();
    	//retorno un int con el valor retornado por la funcion invocada
        return new Integer(f_sendData.getRetVal()).intValue();
    }  	

    /*
     * wrapper de la funcion de la dll:
     * int openDevice(char*, int, int);
    */
    public static int openDevice(int idBoard, String devname, int usbin, int usbout) throws NativeException, IllegalAccessException {
    	if(f_openDevice == null) {
    		//seteo la funcion a invocar
    		//f_openDevice = new JNative(DLL_NAME, "_ZN3u4a10openDeviceERA8_c10USBTransIN11USBTransOUT");
    		f_openDevice = new JNative(DLL_NAME, "_ZN3u4a10openDeviceEiPcii");
    		//seteo tipo de retorno (la dll devuelve un DWORD) 
    		f_openDevice.setRetVal(Type.INT);
    	}	
    	//TODO chequear bien
    	//tengo que agregar un /0 al final
    	int dataLength = devname.length()+1;
    	byte[] data = new byte[dataLength];
    	for(int i = 0 ; i< devname.length(); i++){
    		data[i]=(byte)devname.charAt(i);
    	}
    	data[dataLength-1]=0x00;
    	Pointer pData = new	Pointer(MemoryBlockFactory.createMemoryBlock(dataLength));
		pData.setMemory(data);
		
   	
    	System.out.println("usbin:"+usbin+" usbout:"+usbout);
    	//seteo parametros a pasar
    	//    	RARO para la dll usb4all exportada en c++ se empieza a poner parametros desde el 1
    	f_openDevice.setParameter(1, Type.INT, "" + idBoard);
    	f_openDevice.setParameter(2, pData);
    	f_openDevice.setParameter(3, Type.INT, "" + usbin);
    	f_openDevice.setParameter(4, Type.INT, "" + usbout);
    	//invoco la funcion
    	System.out.println("Antes de hacer invoke() en USB4ALLAPIWrapper::openDevice(..)");
    	f_openDevice.invoke();
    	System.out.println("Despues de hacer invoke() en USB4ALLAPIWrapper::openDevice(..)");
    	//retorno un int con el valor retornado por la funcion invocada
        int ret = new Integer(f_openDevice.getRetVal()).intValue();
        System.out.println("Despues de obtener el ret USB4ALLAPIWrapper::openDevice(..)");
    	return ret;
    }  	
    /*
     * wrapper de la funcion de la dll:
     * bool receiveData(int, char*, int);
     */
    public static ReadBytes receiveData(int handler, int len) throws NativeException, IllegalAccessException {
    	//esta funcion es bloqueante
    	return receiveData(handler,len,-1); 
    }
    public static ReadBytes receiveData(int handler, int len, int timeout) throws NativeException, IllegalAccessException {
    	Pointer pData = new	Pointer(new HeapMemoryBlock(MAX_PACKET_SIZE));
		//Pointer pData = new	Pointer(MemoryBlockFactory.createMemoryBlock(len));
    	if(f_receiveData == null) {
    		//seteo la funcion a invocar
    		f_receiveData = new JNative(DLL_NAME, "_ZN3u4a11receiveDataEiPcii");
        	//seteo tipo de retorno (la dll devuelve un DWORD) 
    		f_receiveData.setRetVal(Type.INT);
    	}	
    	//seteo los parametros de la funcion
    	f_receiveData.setParameter(1, Type.INT, "" + handler);
    	f_receiveData.setParameter(2, pData);
    	f_receiveData.setParameter(3, Type.INT, "" + len);
    	f_receiveData.setParameter(4, Type.INT, "" + timeout);
    	//invoco la funcion
    	f_receiveData.invoke();
    	byte[] readBytes = pData.getMemory();
    	ReadBytes ret=new ReadBytes(readBytes,
    	//TODO sustituir el len por lo que realmente se leyo en la api (PEDIR A CARLOS)
    			len,
    					Integer.parseInt(f_receiveData.getRetVal())); 
    	pData.dispose(); //por las dudas hago el dispose aca
    	return ret;
    }
    
    /*
     * wrapper de la funcion de la dll:
     * int* getU4ABoards(int);
     */
    public static int getU4ABoards() throws NativeException, IllegalAccessException {
    	int INT_SIZE = 4;
    	Pointer pInt = new	Pointer(new HeapMemoryBlock(INT_SIZE));
		
    	if(f_getU4ABoards == null) {
    		//seteo la funcion a invocar
    		f_getU4ABoards = new JNative(DLL_NAME, "_ZN3u4a12getU4ABoardsERi");
        	//seteo tipo de retorno (la dll devuelve un DWORD) 
    		f_getU4ABoards.setRetVal(Type.INT);
    	}	
    	//seteo los parametros de la funcion
    	f_getU4ABoards.setParameter(1, pInt);
    	
    	//invoco la funcion
    	f_getU4ABoards.invoke();
    	//byte[] readInt = pInt.getMemory();
    	int cantBoards =  pInt.getAsInt(0);
    	pInt.dispose();
    	return cantBoards;
    }
    
    /*
     * wrapper de la funcion de la dll:
     * int getSerialNumber(int);
     */
    public static int getSerialNumber(int boardNumber) throws NativeException, IllegalAccessException {
		if(f_getSerialNumber == null) {
            //seteo la funcion a invocar
			f_getSerialNumber = new JNative(DLL_NAME, "_ZN3u4a15getSerialNumberEi");//mia
			
			//seteo tipo de retorno (la dll devuelve un int) 
			f_getSerialNumber.setRetVal(Type.INT);
    	}	
		//RARO para la dll usb4all exportada en c++ se empieza a poner parametros desde el 1
		f_getSerialNumber.setParameter(1, Type.INT, "" + boardNumber);
    	//invoco la funcion
		f_getSerialNumber.invoke();
    	//retorno un int con el valor retornado por la funcion invocada
        return new Integer(f_getSerialNumber.getRetVal()).intValue();
    }
    
    public static void printByteArray(byte[] c){
		//System.out.println("en binario: ");
		for (int i=0;i<c.length;i++){
			String s = Integer.toHexString(Byte.valueOf(c[i]));
			if (s.length()>1) s = s.substring(s.length()-2);
			else s = "0"+s;
			System.out.print(s +" ");
		}
		System.out.println();
	}
    
}


